



<html>
<head>
  <title>javabog.dk -  - Appletter</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel9.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel11.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">10 <a name='afsn10'></a>Appletter</H1>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI VALUE=1><P LANG="da-DK" CLASS="kapiteloversigt-western">At l&aelig;gge
  en Java-applet i en hjemmeside</P>
  <LI><P LANG="da-DK" CLASS="kapiteloversigt-western">Metoder i en
  applet</P>
</UL>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes
ikke i resten af bogen, men appletter anvendes i nogle eksempler i
<a href='kapitel12.jsp'>kapitel 12</a>, Interfaces og 13, H&aelig;ndelser.</P>
<P LANG="da-DK" CLASS="kapiteloversigt-western">Foruds&aelig;tter
<a href='kapitel9.jsp'>kapitel 9</a>, Grafiske programmer og lidt kendskab til HTML.</P>


<P LANG="da-DK" CLASS="western" STYLE="">En
applet er et javaprogram i en hjemmeside. N&aring;r siden vises, vil
netl&aelig;seren (browseren, fremviseren af hjemmesiden) hente
javaprogrammet og udf&oslash;re det p&aring; brugerens maskine. Ordet
&quot;applet&quot; giver mange associationer til &quot;en lille
applikation&quot;.</P>
<H2 CLASS="western">10.1 <a name='afsn10.1'></a>HTML-dokumentet</SPAN></H2>
<P LANG="da-DK" CLASS="western">Hjemmesider skrives i et sprog, der
hedder HTML. For mere viden om HTML henvises til de mange
introduktioner til, hvordan man laver hjemmesider. 
</P>
<P LANG="da-DK" CLASS="western">En side med en applet vil have
HTML-koden &lt;applet&gt;, der henviser til, hvor netl&aelig;seren
skal finde programkoden. Et HTML-dokument med en applet kunne se
s&aring;dan her ud:</P>
<PRE CLASS="ikke-javakode-western">&lt;html&gt;
 &lt;head&gt;
  &lt;title&gt;
   Min applet
  &lt;/title&gt;
 &lt;/head&gt;

 &lt;body&gt;
  Velkommen til min f&oslash;rste applet! &lt;br&gt;
  <B>&lt;applet code=&quot;MinApplet.class&quot; width=&quot;400&quot; height=&quot;300&quot;&gt;&lt;/applet&gt; </B>&lt;br&gt;
  Slut herfra!
 &lt;/body&gt;
&lt;/html&gt;</PRE><P LANG="da-DK" CLASS="western">
Her blev i &lt;applet&gt;-koden angivet, at appletten hedder
MinApplet og at den skal v&aelig;re 400 punkter bred og 300 h&oslash;j.
Filen MinApplet.class (den bin&aelig;re kode, som overs&aelig;tteren
laver ud fra kildetekstfilen MinApplet.java) skal ligge samme sted
som HTML-dokumentet.</P>
<H2 CLASS="western">10.2 <a name='afsn10.2'></a>Javakoden</SPAN></H2>
<P LANG="da-DK" CLASS="western">Selve javaprogrammet er en klasse,
der arver fra JApplet og har en paint()-metode (for appletter bruges
paint() i stedet for paintComponent()), hvor grafikken tegnes.
Eksempel:</P>
<PRE CLASS="kode-western">import java.awt.*;
import javax.swing.*;

public class MinApplet <B>extends JApplet</B>
{
  public void paint(Graphics g)
  {
<I>    // Herunder referer g til et Graphics-objekt man kan tegne med</I>

    super.paint(g);    <I>// tegn f&oslash;rst baggrunden (og evt komponenter)</I>

    g.drawLine(0,0,50,50);

    g.fillOval(5,10,300,30);

    g.setColor(Color.GREEN);

    g.drawString(&quot;Hej grafiske verden!&quot;,100,30);
  }
}</PRE><P LANG="da-DK" CLASS="western">
Det ligner alts&aring; pr&aelig;cist koden fra forrige kapitel
(sammenlign med Grafikpanel <a href='kapitel9.jsp'>kapitel 9</a>), ud over at tegnemetoden her
hedder paint() i stedet for paintComponent() og at vi her arver fra
JApplet i stedet for JPanel. Dog er det ikke n&oslash;dvendigt med en
BenytGrafikpanel-klasse, der &aring;bner vinduet, da netl&aelig;seren
s&oslash;rger for dette ud fra HTML-koden.</P>
<P LANG="da-DK" CLASS="western">Herunder ses, hvordan HTML-koden med
appletten ser ud i en netl&aelig;ser (Netscape p&aring; Linux). Man
ser, at f&oslash;rst kommer HTML-teksten &quot;Velkommen til ...&quot;,
derunder appletten og nederst igen teksten &quot;Slut herfra!&quot;
fra HTML-koden.</P>
<P LANG="da-DK" CLASS="western" ALIGN=CENTER><IMG SRC="bog11_html_30b52402.png" NAME="Grafik1" ALIGN=BOTTOM BORDER=0></P>
<H2 CLASS="western">10.3 <a name='afsn10.3'></a>Metoder i appletter</SPAN></H2>
<P LANG="da-DK" CLASS="western">En applet skal spille sammen med
HTML-koden og fremvisningen. Der ligger faktisk et stort maskineri
bagved, der s&oslash;rger for, at den bliver vist korrekt og f&aring;r
relevante oplysninger om, hvad brugeren g&oslash;r.</P>
<P LANG="da-DK" CLASS="western">Derfor har appletter nogle metoder,
som det kan v&aelig;re nyttigt at kende. De er delt i to grupper,
nemlig dem som <I>du kan kalde</I> og dem som <I>systemet kalder</I>
(og som du kan omdefinere for at f&aring; udf&oslash;rt noget af din
kode, n&aring;r de kaldes).</P>
<H3 CLASS="western">10.3.1 <a name='afsn10.3.1'></a>Metoder i appletter, som du kan kalde</H3>
<P LANG="da-DK" CLASS="western">Disse metoder kan du kalde, n&aring;r
du programmerer appletter. Det er kun de vigtigste af metoderne,
der er gengivet (se Javadokumentationen for en komplet liste).</P>
<P LANG="da-DK" ALIGN=CENTER STYLE="margin-top: 0.21cm; margin-bottom: 0cm">
<FONT SIZE=2 STYLE="font-size: 9pt"><I>Nogle af JApplet-klassens
metoder - se ogs&aring; dem i JFrame-klassen <a href='kapitel9.jsp#afsn9.2'>afsnit 9.2</a>, der er
m&aelig;rket med (generel).</I></FONT></P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">URL
</SPAN><B>getDocumentBase</B>()<BR>giver URL'en til der, hvor
HTML-dokumentet ligger.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">URL
</SPAN><B>getCodeBase</B>()<BR>giver URL'en (adressen) til der, hvor
.class-filen er. Ofte det samme som getDocumentBase().</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">Image
</SPAN><B>getImage</B><SPAN STYLE="font-weight: medium">(URL url,
String filnavn)<BR>returnerer et billede-objekt, typisk fra en .jpg
eller .gif-fil. F.eks kunne et billede, der l&aring; samme sted som
appletten, hentes med </SPAN>getImage(getCodeBase(),&quot;filnavn.gif&quot;).</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><SPAN STYLE="font-weight: medium">AudioClip
</SPAN><B>getAudioClip</B>(URL url, String filnavn)<BR>returnerer et
lydklip-objekt, typisk fra en .wav-fil.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">String
<B>getParameter</B>(String parameternavn)<BR>returnerer den
p&aring;g&aelig;ldende parameterv&aelig;rdi, hvis den er defineret i
HTML-koden, ellers null. En parameter s&aelig;ttes med &lt;param
name=&quot;navn&quot; value=&quot;v&aelig;rdi&quot;&gt; mellem
&lt;applet ...&gt; og &lt;/applet&gt;.</P>
<P LANG="da-DK" CLASS="klasseoversigt-western">void <B>showStatus</B>(String
tekst)<BR>viser en meddelelse i netl&aelig;serens statusfelt (hvor
status for dokumentindl&aelig;sning plejer at st&aring;).</P>
<P LANG="da-DK" CLASS="klasseoversigt-western"><B>getAppletContext().showDocument</B>(URL
url) <BR>omdirigerer netl&aelig;seren til at vise en anden URL i
dette vindue, s&aring;dan at siden med appletten bliver forladt.
Findes ogs&aring; i en variant, der &aring;bner en URL i et nyt/et
andet navngivet vindue.</P>
<P LANG="da-DK" CLASS="western">Bem&aelig;rk: Ovenst&aring;ende
metoder fungerer f&oslash;rst <I>efter</I>, at appletten er
f&aelig;rdigoprettet. Brug dem derfor ikke fra din egen konstrukt&oslash;r,
men defin&eacute;r metoden init() i stedet (se nedenfor).</P>
<H3 CLASS="western">10.3.2 <a name='afsn10.3.2'></a>Metoder i appletter, som systemet kalder</H3>
<P LANG="da-DK" CLASS="western">Disse metoder kan du definere i en
applet. Systemet kalder dem p&aring; bestemte tidspunkter.</P>

<PRE CLASS="ikke-javakode-western">  public void init()</PRE><P LANG="da-DK" CLASS="western">
Kaldes &eacute;n gang, n&aring;r netl&aelig;seren indl&aelig;ser
HTML-dokumentet og appletten. Det er en god ide at placere
programkode, der opretter objekter og initialiserer appletten, i
init(). <BR>Da appletten er et objekt, kan det selvf&oslash;lgelig
ogs&aring; g&oslash;res fra konstrukt&oslash;ren, men v&aelig;r da
opm&aelig;rksom p&aring;, at de metoder, du kan kalde (f.eks.
repaint() og getSize()), ikke fungerer korrekt, da applettens
omgivelser ikke er blevet initialiseret endnu.</P>

<PRE CLASS="ikke-javakode-western">  public void start()</PRE><P LANG="da-DK" CLASS="western">
Kaldes, n&aring;r appletten bliver synlig. Normalt sker det lige
efter init(), men hvis HTML-dokumentet er meget stort og
appletten er i bunden af dokumentet, kan det v&aelig;re, den ikke er
synlig med det samme. S&aring; kaldes start() f&oslash;rst, n&aring;r
appletten bliver synlig for brugeren. start() kan godt blive kaldt
flere gange, hvis appletten skjules og bliver synlig igen.</P>

<PRE CLASS="ikke-javakode-western">  public void paint(Graphics g)</PRE><P LANG="da-DK" CLASS="western">
Her programmerer du, hvordan appletten skal se ud, ligesom forklaret
i <a href='kapitel9.jsp#afsn9.1'>afsnit 9.1</a>. Metoden kaldes, hver gang der er behov for at gentegne
en del eller hele appletten. Det kan v&aelig;re ret s&aring;
ofte, s&aring; man b&oslash;r have s&aring; lidt kode som muligt her,
s&aring; metoden kan udf&oslash;res hurtigt.</P>

<PRE CLASS="ikke-javakode-western">  public void stop()</PRE><P LANG="da-DK" CLASS="western">
Kaldes, n&aring;r appletten bliver skjult, fordi vinduet bliver
minimeret, eller fordi brugeren g&aring;r til et andet dokument
(det sker det samme antal gange, som start() kaldes).</P>

<PRE CLASS="ikke-javakode-western">  public void destroy()</PRE><P LANG="da-DK" CLASS="western">
Kaldes, n&aring;r appletten smides v&aelig;k af netl&aelig;seren,
fordi brugeren er g&aring;et til et andet dokument eller har
lukket vinduet. destroy() bliver kun kaldt &eacute;n gang. Er der
noget, der er vigtigt at f&aring; gjort, inden programmet
afsluttes, kan du l&aelig;gge kode til at g&oslash;re det i
destroy().</P>
<H3 CLASS="western">10.3.3 <a name='afsn10.3.3'></a>Eksempel</H3>
<P LANG="da-DK" CLASS="western">Nedenfor er Kurvetegning fra <a href='kapitel9.jsp#afsn9.1.2'>afsnit 9.1.2</a>
igen som en applet, hvor metoderne, som systemet kalder, alle er
defineret til at udskrive en tekst, n&aring;r de bliver kaldt.</P>
<P LANG="da-DK" CLASS="western">Vi udskriver ogs&aring; st&oslash;rrelsen
af appletten og hvor den kommer fra (getDocumentBase()):</P>
<PRE CLASS="kode-western">Konstrukt&oslash;r kaldt - bredden er her: 0
init()    kaldt   - bredden er her: 400
               URL: file:/home/jacob/bog/kode/kapitel_10/Kurvetegningsapplet.html
start()   kaldt
paint()   kaldt
paint()   kaldt
paint()   kaldt
stop()    kaldt
destroy() kaldt</PRE><P LANG="da-DK" CLASS="western">
Man ser, at r&aelig;kkef&oslash;lgen af kaldene er som beskrevet.
Bem&aelig;rk at mange data (bl.a. applettens st&oslash;rrelse) endnu
ikke er kendt i konstrukt&oslash;ren, men f&oslash;rst i init(). Det
er ogs&aring; f&oslash;rst fra og med init(), at metoder som
getDocumentBase() og showStatus() kan kaldes.</P>
<P LANG="da-DK" CLASS="western">Da appletten er blevet k&oslash;rt
direkte fra harddisken (i /home/jacob/bog/kode/kapitel_10/), giver
kaldet til getDocumentBase() en URL til dette sted p&aring; det
lokale filsystem.</P>
<PRE CLASS="kode-western" STYLE="">import java.util.*;
import java.awt.*;
import javax.swing.*;

public class Kurvetegningsapplet <B>extends JApplet</B>
{
  ArrayList&lt;Color&gt; farver; <I>// objektvariabel kendt i b&aring;de init() og paint()</I>
  int forskydning = 50;    <I>// en forskydning i farvevalget</I>

  public Kurvetegningsapplet()
  {
    System.out.println(&quot;Konstrukt&oslash;r kaldt - bredden er her: &quot;+<B>getSize().width</B>);
  }

<B>  public void init()</B>     <I>// Forbered punkterne i init(), ikke i konstrukt&oslash;ren</I>
  {
    System.out.println(&quot;init()    kaldt   - bredden er her: &quot;+<B>getSize().width</B>);
    System.out.println(&quot;               URL: &quot;+<B>getDocumentBase()</B>);

    farver = new ArrayList&lt;Color&gt;();
    for (int i=0; i&lt;400; i++)
    {
      Color farve = new Color(i%256, (i*2)%256, (i*4)%256);
      farver.add(farve);
    }
  }

  <B>public void start()</B>
  {
    System.out.println(&quot;start()   kaldt&quot;);
  }

  <B>public void paint(Graphics g)</B>                 <I>// ikke  paintComponent()</I>
  {
    System.out.println(&quot;paint()   kaldt&quot;);
    <B>showStatus(</B>&quot;Dette er statuslinjen &quot;+new Date()<B>)</B>;
    g.drawString(&quot;Kurvetegning&quot;, forskydning%400, forskydning%300);
    for (int x=0; x&lt;farver.size(); x++)
    {
      int y = 150 - (int) (120*Math.sin(0.05*x));<IMG SRC="bog11_html_m5a86bae5.png" NAME="Grafik28" ALIGN=RIGHT BORDER=0>
      int i = (x+forskydning)%400;
      Color farve = farver.get(i);
      g.setColor(farve);
      g.fillRect(x, y, 5, 5);
    }
  }

  <B>public void stop()</B>
  {
    System.out.println(&quot;stop()    kaldt&quot;);
  }

  <B>public void destroy()</B>
  {
    System.out.println(&quot;destroy() kaldt&quot;);
  }
}</PRE><H2 CLASS="western">
10.4 <a name='afsn10.4'></a>Resum&eacute;</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel10.jsp#afsn10.4">
  <input type='checkbox' name='vis' value='10.4'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='10.4'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H2 CLASS="western" STYLE="">10.5 <a name='afsn10.5'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel10.jsp#afsn10.5">
  <input type='checkbox' name='vis' value='10.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='10.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">10.5.1 <a name='afsn10.5.1'></a>Sikkerhedsbegr&aelig;nsninger for appletter</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel10.jsp#afsn10.5.1">
  <input type='checkbox' name='vis' value='10.5.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='10.5.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">10.5.2 <a name='afsn10.5.2'></a>Pakker og CODE/CODEBASE i HTML-koden</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel10.jsp#afsn10.5.2">
  <input type='checkbox' name='vis' value='10.5.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='10.5.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">10.5.3 <a name='afsn10.5.3'></a>Begr&aelig;nsninger i &aelig;ldre netl&aelig;sere</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP/kapitel10.jsp#afsn10.5.3">
  <input type='checkbox' name='vis' value='10.5.3'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='10.5.3'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel9.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel11.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (79% af vrket).
</font>
<br>
nsker du at se de sidste 21% af dette vrk (226970 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
